/**
* \file: FrameInternal.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPlay
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2013-2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef CARPLAY_FRAMEINTERNAL_H
#define CARPLAY_FRAMEINTERNAL_H
#define INIT_BUFF 512 //First frame always takes ~220 bytes, irrespective of screen it renders.

#include "IVideoOutAdapter.h"
#include "AirPlayHeaders.h"

namespace adit { namespace carplay
{

class CARPLAY_HIDDEN FrameInternal : public FrameFragment
{
public:
    FrameInternal();
    ~FrameInternal();

    void SetContext(ScreenStreamCompletion_f onComplete, void* context);
    void SetDisplayTime(uint64_t displayTime);
    bool CreateNewBuff(const size_t reqBufsize);
    void Release();
    void Append(const void* data,size_t length);
    inline size_t GetBufSize(){return frameBufsize;}


private:
    ScreenStreamCompletion_f onComplete;
    void* context;
    size_t frameBufsize;

};

} } /* namespace adit { namespace carplay */

#endif /* CARPLAY_FRAMEINTERNAL_H */
